#ifndef __CTGAImage__
#define __CTGAImage__

#include "CBaseImage.hpp"
using Exponent::GUI::Graphics::CBaseImage;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CTGAImage CTGAImage.hpp
			 * @brief A targa image
			 *
			 * @date 29/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CTGAImage.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CTGAImage : public CBaseImage
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================
				
				/**
				 * Construction with a file name
				 * @param filename Name of the file to load
				 * @throws CException On load error
				 */
				CTGAImage(const CSystemString &filename);

				/**
				 * Construction
				 */
				CTGAImage();

				/**
				 * Destruction
				 */
				virtual ~CTGAImage();

//	===========================================================================

				/**
				 * Get the format
				 * @retval EImageFormats The format of the image
				 */
				virtual EImageFormats getImageFormat() const { return e_targa; }

				/**
				 * Load from a file
				 * @param filename The name of the file, expected to be a 32bpp TGA file 
				 * @retval bool True if loaded the image properly, false on error
				 */
				virtual bool loadFromFile(const CSystemString &filename);

//	===========================================================================

				/**
				 * Get a new TGA image instance
				 * @param path The containing folder of the image
				 * @param filename the name of the file
				 * @retval CTGAImage* The new instance or NULL on error
				 */
				static CTGAImage *getNewInstance(const CSystemString &path, const CString &filename);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * @struct STGAHeader CTGAImage.hpp
				 * @brief The header struct for TGA images, 
				 * @note 16 byte aligned
				 */
				struct STGAHeader
				{
					unsigned char m_idLength;			/**< Expects 0 */
					unsigned char m_colourMapType;		/**< Expects 0 */
					unsigned char m_imageType;			/**< Expects 2 : Truecolour */
					unsigned short m_cMapStart;			/**< Expects 0 */
					unsigned short m_cMapLength;		/**< Expects 0 */
					unsigned char m_cMapDepth;			/**< Expects 0 */
					unsigned short m_xOffset;			/**< Expects 0 */
					unsigned short m_yOffset;			/**< Expects 0 */
					unsigned short m_width;				/**< Height of the image */
					unsigned short m_height;			/**< Width of the image */
					unsigned char m_pixelDepth;			/**< Expects 32 */
					unsigned char m_imageDescriptor;	/**< Expects 8 for 8 bit alpha */
				};
			};
		}
	}
}
#endif	// End of CTGAImage.hpp